#'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"#
#~	CC6 Generic PC_LINT Makefile	~#
#'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"#

#refer to this makefiles usage instructions
CC6_PC_LINT_first: CC6_PC_LINT_usage
	

#for debug set to non-empty:
DEBUG = 

#include the platform constant commands and definitions
include $(MF_PATH)CC6_CMDS.inc

#The components makefiles will be included but their objects will not be built
DEPENDENCIES := $(CC6_GEN_ID)

COMPONENTS :=  $(VOS_ID) $(FVOS_ID) $(INIT_ID) \
    $(CRYS_ID) $(FLOW_ID) $(KMNG_ID) $(CRYS_KMNG_ID) $(TLK_ODRM_ID) $(TLK_CERT_ID) $(NVS_ID) \
    $(SST_ID) $(CRYS_SST_ID) $(MNG_ID) \
    $(SHARED_ATP_ID) $(CRYS_ATP_ID) $(SST_ATP_ID) $(KMNG_ATP_ID) $(TLK_ODRM_ATP_ID) $(TLK_CERT_ATP_ID) $(MNG_ATP_ID) $(MW_ATP_ID)

COMPONENTS_MF = $(addprefix $(MF_PATH),$(addsuffix .$(MFEXT),$(DEPENDENCIES) $(COMPONENTS)))
include $(COMPONENTS_MF)

PC_LINT_PREFIX = CC6_
PC_LINT_SUFFIX = .$(PC_LINTEXT)

PC_LINT_TARGETS = $(addsuffix _OBJECTS_TARGET, $(COMPONENTS))

TARGETS = $(addprefix $(OUT_PC_LINT_PATH)$(PC_LINT_PREFIX), $(addsuffix $(PC_LINT_SUFFIX), $(COMPONENTS)))

CC6_PC_LINT_main: CC6_PC_LINT_debug COMP_debug $(OUT_OBJ_PATH) $(OUT_PC_LINT_PATH) $(PC_LINT_TARGETS) $(TARGETS)
	$(ECHO) $@ STOP.

#for debug set to the wanted component id:
COMP_NAME = $(VOS_ID)

TYPE = type
#dynamically(with auto-var) get atp component objects:
PC_LINT_COMPONENT_STRIPPED = $(subst $(OUT_PC_LINT_PATH)$(PC_LINT_PREFIX),,$(subst $(PC_LINT_SUFFIX),,$@))
PC_LINT_COMPONENT_OBJS = $($(PC_LINT_COMPONENT_STRIPPED)_OBJS)
PC_LINT_COMPONENT_MAIN_OBJS = $($(PC_LINT_COMPONENT_STRIPPED)_MAIN_OBJS)
PC_LINT_COMPONENT_USED_OBJS = $($(PC_LINT_COMPONENT_STRIPPED)_USE_OBJS)
PC_LINT_OBJS_LIST_TEMP = $(PC_LINT_COMPONENT_OBJS) $(PC_LINT_COMPONENT_MAIN_OBJS) $(PC_LINT_COMPONENT_USED_OBJS)
PC_LINT_OBJS_LIST = $(subst /,$(DIR_SEP),$(PC_LINT_OBJS_LIST_TEMP))


#the individual targets do not have prerequisites because PC_LINT objects are prerequisites to the PC_LINT_main
$(OUT_PC_LINT_PATH)$(PC_LINT_PREFIX)%$(PC_LINT_SUFFIX): $(PC_LINT_TARGETS)
	$(DEBUG_ECHO) target $@
	$(DEBUG_ECHO) PC_LINT_COMPONENT_STRIPPED $(PC_LINT_COMPONENT_STRIPPED)
	$(DEBUG_ECHO) PC_LINT_COMPONENT_MAIN_OBJS $(PC_LINT_COMPONENT_MAIN_OBJS)
	$(DEBUG_ECHO) PC_LINT_COMPONENT_OBJS $(PC_LINT_COMPONENT_OBJS)
	$(DEBUG_ECHO) PC_LINT_COMPONENT_USED_OBJS $(PC_LINT_COMPONENT_USED_OBJS)
	$(DEBUG_ECHO) PC_LINT_OBJS_LIST $(PC_LINT_OBJS_LIST)
	$(DEBUG_ECHO) PC_LINT_OBJS_LIST_TEMP $(PC_LINT_OBJS_LIST_TEMP)
	$(TYPE) $(subst /,$(DIR_SEP),$(PC_LINT_OBJS_LIST_TEMP)) 2>&1 > $@ 

CC6_PC_LINT_debug: 
	$(ECHO) PROJECT: $(PROJECT)
	$(ECHO) TARGETS: $(TARGETS)
	$(ECHO) COMPONENTS: $(COMPONENTS)
	$(ECHO) DEPENDENCIES: $(DEPENDENCIES)
	$(DEBUG_ECHO) COMPONENTS_MF $(COMPONENTS_MF)

COMP_debug:
	$(DEBUG_ECHO) COMP_NAME $(COMP_NAME)
	$(DEBUG_ECHO) $(COMP_NAME)_API_INCL_PATH $($(COMP_NAME)_API_INCL_PATH)
	$(DEBUG_ECHO) $(COMP_NAME)_INCL_PATHS $($(COMP_NAME)_INCL_PATHS)
	$(DEBUG_ECHO) $(COMP_NAME)_DEPEND_ON_APIS $($(COMP_NAME)_DEPEND_ON_APIS)
	$(DEBUG_ECHO) $(COMP_NAME)_CCFLAGS $($(COMP_NAME)_CCFLAGS)
	$(DEBUG_ECHO) $(COMP_NAME)_OBJECTS_CCFLAGS $($(COMP_NAME)_OBJECTS_CCFLAGS)
	$(DEBUG_ECHO) $(COMP_NAME)_OBJS $($(COMP_NAME)_OBJS)

CC6_PC_LINT_clean:
	$(ECHO) Deleting all previous PC_LINT output...
	-@$(RM) $(OUT_OBJ_PATH:/=$(DIR_SEP))*.$(OBJEXT)
	-@$(RM) $(OUT_PC_LINT_PATH:/=$(DIR_SEP))*.$(PC_LINTEXT)
	$(ECHO) Done.

$(OUT_OBJ_PATH) $(OUT_PC_LINT_PATH):
	-$(MKDIR) $(@:/=$(DIR_SEP))

CC6_PC_LINT_rebuild: CC6_PC_LINT_clean CC6_PC_LINT_main
	

CC6_PC_LINT_usage:
	@echo This makefile should not run on its own.
	@echo It's meant to be used by another makefile for generic PC_LINT build.